/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.panel.pa.svchist;

import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.panel.pa.TypeOneBean;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;

public class ServiceHistorySummaryBean
extends TypeOneBean {
    private static final String TABLE_NAME = "ServiceHistoryTable";
    private static final String TRACE_MASKT = "XPAXSHST";
    private static final String TRACE_MASKF = "XPAXSHSF";
    private static final String TRACE_MASKD = "XPAXSHSD";
    private static final Comparator compareByDate = new Comparator(){

        public int compare(Object o1, Object o2) {
            return (int)(((ContentElement)o2).date.getTime() - ((ContentElement)o1).date.getTime());
        }
    };
    private static final Comparator compareBySystemName = new Comparator(){

        public int compare(Object o1, Object o2) {
            int systemValue = ((ContentElement)o1).system.compareTo(((ContentElement)o2).system);
            if (systemValue == 0) {
                int probNumValue = ((ContentElement)o1).problem.compareTo(((ContentElement)o2).problem);
                if (probNumValue > 0) {
                    return -1;
                }
                return 1;
            }
            return systemValue;
        }
    };
    private static final Comparator compareByStatus = new Comparator(){

        public int compare(Object o1, Object o2) {
            int value = ((ContentElement)o1).status.toString().compareTo(((ContentElement)o2).status.toString());
            if (value == 0) {
                int systemValue = ((ContentElement)o1).system.compareTo(((ContentElement)o2).system);
                if (systemValue == 0) {
                    int probNumValue = ((ContentElement)o1).problem.compareTo(((ContentElement)o2).problem);
                    if (probNumValue > 0) {
                        return -1;
                    }
                    return 1;
                }
                return systemValue;
            }
            if (value > 0) {
                return -1;
            }
            return 1;
        }
    };
    ArrayList content = new ArrayList();

    public ServiceHistorySummaryBean() {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} <init>");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} prepare() entry.");
        this.userTaskManager.setCaptionText("TypeOnePanel", "Service History");
    }

    public void addDataRow(Date date, String system, String problem, LocalizableText status, LocalizableText description) {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} addDataRow(" + date + "," + system + "," + problem + "," + status + "," + description + ").");
        this.content.add(new ContentElement(date, system, problem, status, description));
    }

    public void addServiceHistorySummaryBean(ServiceHistorySummaryBean other) {
        Iterator iterator = other.content.iterator();
        while (iterator.hasNext()) {
            this.content.add(iterator.next());
        }
    }

    public ServiceHistorySummaryBean sortByDate() {
        Collections.sort(this.content, compareByDate);
        return this;
    }

    public ServiceHistorySummaryBean sortBySystemName() {
        Collections.sort(this.content, compareBySystemName);
        return this;
    }

    public ServiceHistorySummaryBean sortByStatus() {
        Collections.sort(this.content, compareByStatus);
        return this;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} panelAction( " + event + " )");
        if (event.getActionCommand().equals("CANCEL")) {
            this.dispose();
        } else {
            int[] selectedRows = this.userTaskManager.getSelectedRows(TABLE_NAME);
            String[] systems = null;
            String[] problems = null;
            if (selectedRows == null || selectedRows.length == 0) {
                if (!this.content.isEmpty()) {
                    Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} panelAction( " + event + " ) nothing selected, defaulting to first item.");
                    ContentElement ce = (ContentElement)this.content.get(0);
                    systems = new String[]{ce.system};
                    problems = new String[]{ce.problem};
                } else {
                    Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} panelAction( " + event + " ) nothing selected, nothing to select, ignored");
                }
            } else {
                systems = new String[selectedRows.length];
                problems = new String[selectedRows.length];
                int i = 0;
                while (i < selectedRows.length) {
                    ContentElement ce = (ContentElement)this.content.get(selectedRows[i]);
                    systems[i] = ce.system;
                    problems[i] = ce.problem;
                    ++i;
                }
            }
            if (systems != null) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("event", event);
                request.setData("system", systems);
                request.setData("problem", problems);
                request.setData("command", event.getActionCommand());
                this.postTaskletRequest(request);
            }
        }
    }

    public int getServiceHistoryTableRowCount() {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} getServiceHistoryTableRowCount()");
        return this.content.size();
    }

    public void update(Object newData) {
        ServiceHistorySummaryBean newBean = (ServiceHistorySummaryBean)newData;
        this.content = newBean.content;
        this.userTaskManager.refreshContainer(TABLE_NAME);
    }

    public ItemDescriptor[] getServiceHistoryTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "{ServiceHistorySummaryBean} getServiceHistoryTableRowAt(" + index + ")");
        ContentElement ce = (ContentElement)this.content.get(index);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ce.date);
        return new ItemDescriptor[]{new DateItemDescriptor("date." + index, calendar), new TimeItemDescriptor("time." + index, calendar), new ItemDescriptor("name." + index, ce.system), new ItemDescriptor("number." + index, ce.problem), new ItemDescriptor("status." + index, ce.status.toString()), new ItemDescriptor("description." + index, ce.description.toString())};
    }

    class CompareByDate
    implements Comparator {
        CompareByDate() {
        }

        public int compare(Object o1, Object o2) {
            return (int)(((ContentElement)o1).date.getTime() - ((ContentElement)o2).date.getTime());
        }
    }

    public class ContentElement
    implements Serializable {
        public Date date;
        public String system;
        public String problem;
        public LocalizableText status;
        public LocalizableText description;

        ContentElement(Date date, String system, String problem, LocalizableText status, LocalizableText description) {
            this.date = date;
            this.system = system;
            this.problem = problem;
            this.status = status;
            this.description = description;
        }
    }
}

